<?php
/**
 * Plugin Name: ShopLentor Pro – WooCommerce Builder for Elementor & Gutenberg
 * Description: An all-in-one WooCommerce solution to create a beautiful WooCommerce store.
 * Plugin URI: https://elementorfa.ir/
 * Version: 	2.6.9
 * Author: ElementorFa
 * Author URI: https://elementorfa.ir/
 * License:  	GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: woolentor-pro
 * Domain Path: /languages
 * Requires Plugins: woocommerce
 * WC tested up to: 10.2.2
 * Elementor tested up to: 3.32.4
 * Elementor Pro tested up to: 3.32.2
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

update_option( 'WooLentorPro_lic_Key', 'activated' );
update_option( 'WooLentorPro_lic_email', 'noreply@gmail.com' );

define( 'WOOLENTOR_VERSION_PRO', '2.6.9' );
define( 'WOOLENTOR_ADDONS_PL_ROOT_PRO', __FILE__ );
define( 'WOOLENTOR_ADDONS_PL_URL_PRO', plugins_url( '/', WOOLENTOR_ADDONS_PL_ROOT_PRO ) );
define( 'WOOLENTOR_ADDONS_PL_PATH_PRO', plugin_dir_path( WOOLENTOR_ADDONS_PL_ROOT_PRO ) );
define( 'WOOLENTOR_ADDONS_DIR_URL_PRO', plugin_dir_url( WOOLENTOR_ADDONS_PL_ROOT_PRO ) );
define( 'WOOLENTOR_TEMPLATE_PRO', trailingslashit( WOOLENTOR_ADDONS_PL_PATH_PRO . 'includes/templates' ) );

// Required File
require_once ( WOOLENTOR_ADDONS_PL_PATH_PRO.'includes/base.php' );
\WooLentorPro\woolentor_pro();

// Compatible With WooCommerce Custom Order Tables
add_action( 'before_woocommerce_init', function() {
	if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

// Added by Plugin Modifier
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;
    require 'lib/plugin-update-checker/plugin-update-checker.php';
    $myUpdateChecker = PucFactory::buildUpdateChecker(
        'https://api.elementorfa.ir/updater/plugin-api-checker.php?plugin=woolentor-addons-pro&auth=yKt8fP3xQw7zVc2bRj5mEs9dAh6gNu',
        __FILE__,
        'woolentor-addons-pro-updater'
    );
