<?php
/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://posimyth.com/
 * @since      1.0.0
 *
 * @package    ThePlus
 */

namespace TheplusAddons\Widgets;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
$controls_manager = \Elementor\Plugin::instance()->controls_manager;


$this->start_controls_section(
	'theplus_section_needhelp',
	array(
		'label' => esc_html__( 'Need Help?', 'theplus' ),
		'tab'   => Controls_Manager::TAB_CONTENT,
	)
);
if ( $controls_manager->get_control( 'tpae_need_help' ) ) {
	$this->add_control(
		'theplus_help_requests',
		[
			'label' => __( 'Need Help', 'theplus' ),
			'type'  => 'tpae_need_help',
		]
	);
}

$this->end_controls_section();
