( function( $ ) {
    "use strict";
    elementor.hooks.addFilter( 'editor/style/styleText', function( css, context ) {
        if ( ! context ) {
            return;
        }
        
        var model = context.model,
            customCSS = model.get('settings').get('plus_custom_css'),
            selector = '.elementor-element.elementor-element-' + model.get('id');

        var thisID = model.attributes.id,
            addClass = '.elementor-element-'+thisID;

        selector = elementor.config.document.settings.cssWrapperSelector;
        selector += ' ' + addClass;

        if ( customCSS ) {
            css += customCSS.replace(/selector/g, selector);
        }

        return css;
    });

}( jQuery ) );