<?php
/**
 * Plugin Name: Hide White Label (All Locations)
 * Description: حذف آیتم «وایت لیبل» از منوی پیشخوان، ادمین بار و بخش تنظیمات قالب.
 * Author: Amishbala
 * Version: 3.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

// 🔹 آرایه شناسه‌ها یا attribute هایی که باید حذف شوند
$ah_white_label_ids = [
    'wd_white_label_section', // Admin Bar
    'wp-admin-bar-wd_white_label_section', // Admin Bar احتمالی دیگر
    'white_label_section', // Submenu و بخش تنظیمات قالب
];

// حذف Admin Bar
function ah_remove_white_label_admin_bar( $ids ) {
    global $wp_admin_bar;
    if ( ! is_object( $wp_admin_bar ) ) return;

    foreach ( $ids as $id ) {
        $wp_admin_bar->remove_node( $id );
    }
}

// حذف Submenu وردپرس
function ah_remove_white_label_admin_menu( $ids ) {
    foreach ( $ids as $id ) {
        remove_submenu_page( 'xts_theme_settings', 'xts_theme_settings&tab=' . $id );
    }
}

// اضافه کردن CSS/JS برای مخفی کردن بخش‌های HTML دلخواه در قالب
function ah_hide_white_label_custom_html( $ids ) {
    echo '<style>';
    foreach ( $ids as $id ) {
        // اگر attribute data-id وجود دارد
        echo 'a[data-id="' . esc_attr($id) . '"], ';
        echo 'li.' . esc_attr($id) . ' { display: none !important; }';
    }
    echo '</style>';
}

/**
 * تابع فعال‌سازی افزونه
 */
function ah_enable_hide_white_label( $ids ) {
    add_action( 'admin_bar_menu', function() use ( $ids ) {
        ah_remove_white_label_admin_bar( $ids );
    }, 999 );

    add_action( 'admin_menu', function() use ( $ids ) {
        ah_remove_white_label_admin_menu( $ids );
    }, 999 );

    add_action( 'admin_head', function() use ( $ids ) {
        ah_hide_white_label_custom_html( $ids );
    }, 999 );
}

/* ----------------------------------------------------------
   🔻 فقط این خط را برای فعال / غیرفعال کردن افزونه کنترل کن
   ---------------------------------------------------------- */

ah_enable_hide_white_label( $ah_white_label_ids );
