<?php
/**
* Ippanel SMS API Class - version 7.9.3
*/
if(!class_exists('digits_Ippanel')){
class digits_Ippanel {

  private $username;
  private $apikey;
  private $sendbyapikey = false;

  private $Password;

  private $sender;

  private $domain = 'ippanel.com';
  
  /**
  * Create a new instance of the Clockwork wrapper
  */
  public function __construct($arg ,array $options = array()) {
    if (empty($arg)) {
      error_log("Username and Password and Sender can't be blank");
    } else {
		if(isset($arg['apikey'])){
		  $this->apikey = trim($arg['apikey']);
		  $this->sendbyapikey = true;
		}else{
		  $this->username = trim($arg['username']);
		  $this->password = trim(stripslashes($arg['password']));
		}
      $this->sender = trim($arg['sender']);
      if(isset($arg['domain']) && $arg['domain'] !== '') $this->domain = trim($arg['domain']);
    }
  }

  /**
  * Send messages
  */
  public function send(array $sms) {

    if (!is_array($sms)) {
      error_log("sms parameter must be an array");
    }
      if(!is_callable('curl_init')){
          die('CURL function does not exist in your server. contact your host service!');
      }
	if($this->sendbyapikey) return $this->sendAPI($sms);
	$url = $this->domain.'/services.jspd';
    switch($sms['type']){
        case 'normal' :
            $rcpt_nm = array($sms['to']);

            $param = array
            (
                'uname'=> $this->username,
                'pass'=>$this->password,
                'from'=>$this->sender,
                'message'=> $sms['message'],
                'to'=>json_encode($rcpt_nm),
                'op'=>'send',
            );
            $result = $this->curl($url,$param,'POST',false);
            break;
        case 'pattern' :
            $text = $sms['message'];
            $to = array($sms['to']);
            $splited = explode(';', $text);
            $pattern_code_array = explode(':', $splited[0]);
            $pattern_code = $pattern_code_array[1];
            unset($splited[0]);
            $resArray = array();
            foreach ($splited as $parm) {
                $splited_parm = explode(':', $parm, 2);
                $resArray[$splited_parm[0]] = $splited_parm[1];
            }
            $user = $this->username;
            $pass = $this->password;
            $fromNum = $this->sender;
            $toNum = $to;
            $input_data = $resArray;
            $param = array
            (
                'uname'=> $this->username,
                'pass'=>$this->password,
                'from'=>$this->sender,
                'message'=> $sms['message'],
                'to'=>json_encode($to),
                'op'=>'sendPattern',
            );
            $url = $this->domain."/patterns/pattern?username=".$user."&password=".urlencode($pass)."&from=".$fromNum."&to=".json_encode($toNum)."&input_data=".urlencode(json_encode($input_data))."&pattern_code=$pattern_code";
            $result = $this->curl($url,$param,'GET');
            break;
        case 'internationalnormal' :
            break;
        case 'internationalpattern' :
            break;
    }

    return $result;
  }
  
  /**
  * Send messages
  */
  public function sendAPI(array $sms) {

    if (!is_array($sms)) {
      error_log("sms parameter must be an array");
    }
      switch($sms['type']){
          case 'normal' :
              $rcpt_nm = array($sms['to']);
              $param = array(
                  'originator'=>$this->sender,
                  'message'=>$sms['message'],
                  'recipients'=>$rcpt_nm
              );
              $url = "rest.".$this->domain."/v1/messages";
              $headers = ['Accept: application/json', 'Content-Type: application/json','Authorization: AccessKey '.$this->apikey];
              $resJson = $this->curl($url,$param,'POST',true, $headers);
              $resArray = json_decode($resJson,true);
              if(isset($resArray['status']) && isset($resArray['data']['bulk_id'])){
                  $result = json_encode(array('0',$resArray['data']['bulk_id']));
              } else {
                  $result = json_encode(array($resArray['code'],$resArray['data']['error']));
              }
              break;
          case 'pattern' :
              $text = $sms['message'];
              $splited = explode(';', $text);
              $pattern_code_array = explode(':', $splited[0]);
              $pattern_code = $pattern_code_array[1];
              unset($splited[0]);
              $input_data = array();
              foreach ($splited as $parm) {
                  $splited_parm = explode(':', $parm, 2);
                  $input_data[$splited_parm[0]] = $splited_parm[1];
              }
              $url = "rest.".$this->domain."/v1/messages/patterns/send";
              $param = array(
                  "pattern_code"=> $pattern_code,
                  "originator"=> $this->sender,
                  "recipient"=> $sms['to'],
                  "values"=>$input_data
              );
              $headers = array(
                  'Accept: application/json',
                  'content-type: application/json',
                  'Authorization: AccessKey '.$this->apikey
              );

              $resJson = $this->curl($url,$param,'POST', true, $headers);
              $resArray = json_decode($resJson,true);
              if(isset($resArray['status']) && isset($resArray['data']['bulk_id'])){
                  $result = json_encode(array('0',$resArray['data']['bulk_id']));
              } elseif(isset($resArray['code'])){
                  $result = json_encode(array($resArray['code'],$resArray['data']['error']));
              }
              break;
          case 'internationalnormal' :

              $rcpt_nm = array($sms['to']);
              $param = array(
                  'message'=>$sms['message'],
                  'recipient'=>$rcpt_nm,
                  'sender'=> "+98international",
                  'description' => array(
                        "summary"=> "eeeew",
                        "count_recipient" => "1",
                    ),
              );
              $url = "https://api2.".$this->domain."/api/v1/sms/send/panel/single";
              $headers = array(
                  "apikey: ".$this->apikey,
                  "cache-control: no-cache",
                  "content-type: application/json",
              );

              $resJson = $this->curl($url, $param,'POST',true , $headers);
              $resArray = json_decode($resJson,true);
              if(isset($resArray['status']) && isset($resArray['data']['message_id'])){
                  $result = json_encode(array('0',$resArray['data']['message_id']));
              } elseif(isset($resArray['error_message'])) {
                  $result = json_encode(array($resArray['code'],$resArray['error_message']));
              } else{
                  $result = json_encode(array('403','undefined error'));
              }
              break;
          case 'internationalpattern' :
              $text = $sms['message'];
              $splited = explode(';', $text);
              $pattern_code_array = explode(':', $splited[0]);
              $pattern_code = $pattern_code_array[1];
              unset($splited[0]);
              $input_data = array();
              foreach ($splited as $parm) {
                  $splited_parm = explode(':', $parm, 2);
                  $input_data[$splited_parm[0]] = $splited_parm[1];
              }
              $url = "https://api2.".$this->domain."/api/v1/sms/pattern/normal/send";
              $param = array(
                  "code"=> $pattern_code,
                  "sender"=> "+98international",
                  "recipient"=> $sms['to'],
                  "variable"=>$input_data,
              );
              $headers = array(
                  "apikey: ".$this->apikey,
                  "cache-control: no-cache",
                  "content-type: application/json",
              );

              $resJson = $this->curl($url, $param,'POST',true , $headers);
              $resArray = json_decode($resJson,true);
              if(isset($resArray['status']) && isset($resArray['data']['message_id'])){
                  $result = json_encode(array('0',$resArray['data']['message_id']));
              } elseif(isset($resArray['error_message'])) {
                  $result = json_encode(array($resArray['code'],$resArray['error_message']));
              } else{
                  $result = json_encode(array('403','undefined error'));
              }
              break;
          case 'voice' :
              $ip = isset($_SERVER["HTTP_CF_CONNECTING_IP"]) ? $_SERVER["HTTP_CF_CONNECTING_IP"] : $_SERVER["REMOTE_ADDR"];
              global $wpdb;
              $table_name = $wpdb->prefix . "digits_requests_log";

              $lastotp = $wpdb->get_row(
                  $wpdb->prepare(
                      'SELECT * FROM ' . $table_name . ' WHERE ip = %s', $ip
                  )
              );
              if($lastotp){
                  $time = strtotime($lastotp->time);
                  $current = strtotime("now");
                  //error_log(json_encode(array($lastotp,$time,$current,$current - $time)));
                  if ($current - $time < 60) {
                     // error_log('not_send'. $current - $time);
                      return json_encode(array('403','undefined error'));
                  } else {
                      $db = $wpdb->replace($table_name, array(
                          'ip' => $ip,
                          'requests' => 1,
                          'time' => date("Y-m-d H:i:s", strtotime("now"))
                      ), array(
                              '%s',
                              '%s',
                              '%s'
                          )
                      );
                  }
              } else {
                  $db = $wpdb->replace($table_name, array(
                      'ip' => $ip,
                      'requests' => 1,
                      'time' => date("Y-m-d H:i:s", strtotime("now"))
                  ), array(
                          '%s',
                          '%s',
                          '%s'
                      )
                  );
              }

              $param = array(
                  'otp'=>$sms['otp'],
                  'recipient'=>$sms['to'],
              );
              $url = "https://api2.".$this->domain."/api/v1/sms/send/voice/otp";
              $headers = array(
                  "apikey: ".$this->apikey,
                  "cache-control: no-cache",
                  "content-type: application/json",
              );
              $resJson = $this->curl($url, $param,'POST',true , $headers);

              if($resJson == 'You cant Access this route'){
                  $result = json_encode(array('13403','You cant Access this route'));
              } else {
                  $resArray = json_decode($resJson, true);
                  if (isset($resArray['status']) && isset($resArray['data']['message_id'])) {
                      $result = json_encode(array('0', $resArray['data']['message_id']));
                  } elseif (isset($resArray['error_message'])) {
                      $result = json_encode(array($resArray['code'], $resArray['error_message']));
                  } else {
                      $result = json_encode(array('403', 'undefined error'));
                  }
              }
              break;
      }
      return $result;
  }

  /**
  * Check how much credits you have available
  * @return  integer   panel credit remaining
  */
	public function checkCredit() {
		$result = array();
		$url = $this->domain.'/services.jspd';
		$param = array
					(
						'uname'=>$this->username,
						'pass'=>$this->password,
						'op'=>'credit',
					);

		$credit = json_decode($this->curl($url,$param,'POST'));
		if($credit[0] == 0){
			$result['auth'] = true;
			$result['credit'] = round($credit[1]);
			$param['op'] = 'lines';
			$userlines = json_decode($this->rangine_curl($url,$param));
			foreach (json_decode($userlines[1]) as $line) {
				$lines[] = str_replace('+98', '', json_decode($line)->number);
			}
			if(isset($this->sender) && $this->sender != ''){
				$sender = str_replace('+98', '', trim($_POST['sender']));
				$result['ownSenderLine'] = in_array($sender, $lines);
			}else {
				$result['ownSenderLine'] = 'null';
			}	
		}
		return json_encode($result);
	}
  /**
  * Check patterncode
  * @return  integer   credit remaining
  */
	public function checkPattern($patternCode) {
		$params = array(
			'uname'=> $this->username,
			'pass'=> $this->password,
			'patternCode'=> trim($patternCode),
			'op'=> 'getPatternParams',
			'curl_type' => 'POST'
		);
		$url = $this->domain."/api/select";
		$handler = curl_init($url);    
		curl_setopt($handler, CURLOPT_CONNECTTIMEOUT, 5); 
		curl_setopt($handler, CURLOPT_TIMEOUT, 20);			
		curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($handler, CURLOPT_POSTFIELDS, json_encode($params));                       
		curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
		return curl_exec($handler);
	}
  /**
  * Check patterncode with apikey
  * @return  integer   credit remaining
  */
	public function checkPatternApikey($patternCode) {
		return json_encode(array("status"=>array("code"=>500,"errorMessage"=>"","level"=>1),"data"=>array()));
		$params = array(
			'uname'=> $this->username,
			'pass'=> $this->password,
			'patternCode'=> trim($patternCode),
			'op'=> 'getPatternParams',
			'curl_type' => 'POST'
		);
		$url = $this->domain."/api/select";
		$handler = curl_init($url);    
		curl_setopt($handler, CURLOPT_CONNECTTIMEOUT, 5); 
		curl_setopt($handler, CURLOPT_TIMEOUT, 20);			
		curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($handler, CURLOPT_POSTFIELDS, json_encode($params));                       
		curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
		return curl_exec($handler);
	}
	private function curl($url, $param, $type, $jsonParam = true, $headers = array()){
        //$array_params = $param;
		if($jsonParam) $param = json_encode((object)$param);

		$handler = curl_init($url);
        if($headers){
            curl_setopt($handler, CURLOPT_HTTPHEADER, $headers);
        }

		curl_setopt($handler, CURLOPT_CONNECTTIMEOUT, 15);
		curl_setopt($handler, CURLOPT_TIMEOUT, 30);
		curl_setopt($handler, CURLOPT_MAXREDIRS, 10);
		curl_setopt($handler, CURLOPT_CUSTOMREQUEST, $type);
		if($type == 'POST') curl_setopt($handler, CURLOPT_POSTFIELDS, $param);                       
		curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
		$result = curl_exec($handler);
        //error_log(json_encode([$url, $array_params, $type, $jsonParam , $headers ,json_decode($result,true)]));
		if (curl_errno($handler)) {
			$result = curl_error($handler);
			return json_encode(array('-1',$result));
		}
		return $result;
	}
	/**
	 * لیست خطاهای وب سرویس
	 */
	public function errors_describe($error){
	 $errorCodes = array(
	  '-1'  => 'ارتباط با سامانه پیامک انجام نشد.',
	  '0' => 'عملیات با موفقیت انجام شده است.',
	  '1' => 'متن پیام خالی می باشد.',
	  '2' => 'کاربر محدود گردیده است.',
	  '3' => 'خط به شما تعلق ندارد.',
	  '4' => 'گیرندگان خالی است.',
	  '5' => 'اعتبار کافی نیست.',
	  '7' => 'خط مورد نظر برای ارسال انبوه مناسب نمیباشد.',
	  '9' => 'خط مورد نظر در این ساعت امکان ارسال ندارد.',
	  '98' => 'حداکثر تعداد گیرنده رعایت نشده است.',
	  '99' => 'اپراتور خط ارسالی قطع می باشد.',
	  '21' => 'پسوند فایل صوتی نامعتبر است.',
	  '22' => 'سایز فایل صوتی نامعتبر است.',
	  '23' => 'تعداد تالش در پیام صوتی نامعتبر است.',
	  '100' => 'شماره مخاطب دفترچه تلفن نامعتبر می باشد.',
	  '101' => 'شماره مخاطب در دفترچه تلفن وجود دارد.',
	  '102' => 'شماره مخاطب با موفقیت در دفترچه تلفن ذخیره گردید.',
	  '111' => 'حداکثر تعداد گیرنده برای ارسال پیام صوتی رعایت نشده است.',
	  '131' => 'تعداد تالش در پیام صوتی باید یکبار باشد.',
	  '132' => 'آدرس فایل صوتی وارد نگردیده است.',
	  '266' => 'شما نمی توانید از خط اشتراکی استفاده نمایید.',
	  '301' => 'از حرف ویژه در نام کاربری استفاده گردیده است.',
	  '302' => 'قیمت گذاری انجام نگردیده است.',
	  '303' => 'نام کاربری وارد نگردیده است.',
	  '304' => 'نام کاربری قبال انتخاب گردیده است.',
	  '305' => 'نام کاربری وارد نگردیده است.',
	  '306' => 'کد ملی وارد نگردیده است.',
	  '307' => 'کد ملی به خطا وارد شده است.',
	  '308' => 'شماره شناسنامه نا معتبر است.',
	  '309' => 'شماره شناسنامه وارد نگردیده است.',
	  '310' => 'ایمیل کاربر وارد نگردیده است.',
	  '311' => 'شماره تلفن وارد نگردیده است.',
	  '312' => 'تلفن به درستی وارد نگردیده است.',
	  '313' => 'آدرس شما وارد نگردیده است.',
	  '314' => 'شماره موبایل را وارد نکرده اید.',
	  '315' => 'شماره موبایل به نادرستی وارد گردیده است.',
	  '316' => 'سطح دسترسی به نادرستی وارد گردیده است.',
	  '317' => 'کلمه عبور وارد نگردیده است.',
	  '404' => 'پترن در دسترس نیست.',
	  '455' => 'ارسال در آینده برای کد بالک ارسالی لغو شد.',
	  '456' => 'کد بالک ارسالی نامعتبر است.',
	  '458' => 'کد تیکت نامعتبر است.',
	  '964' => 'شما دسترسی نمایندگی ندارید.',
	  '962' => 'نام کاربری یا کلمه عبور نادرست می باشد.',
	  '963' => 'دسترسی نامعتبر می باشد.',
	  '971' => 'پترن ارسالی نامعتبر است.',
	  '970' => 'پارامتر های ارسالی برای پترن نامعتبر است.',
	  '972' => 'دریافت کننده برای ارسال پترن نامعتبر می باشد.',
	  '992' => 'ارسال پیام از ساعت 8 تا 23 می باشد.',
	  '993' => 'دفترچه تلفن باید یک آرایه باشد',
	  '994' => 'لطفا تصویری از کارت بانکی خود را از منو مدارک ارسال کنید',
	  '995' => 'جهت ارسال با خطوط اشتراکی سامانه، لطفا شماره کارت بانکی خود را به دلیل تکمیل فرایند احراز هویت از بخش ارسال مدارک ثبت نمایید.',
	  '996' => 'پترن فعال نیست.',
	  '997' => 'شما اجازه ارسال از این پترن را ندارید.',
	  '998' => 'کارت ملی یا کارت بانکی شما تایید نشده است.',
	  '1001' => 'فرمت نام کاربری درست نمی باشد)حداقله ۵ کاراکتر، فقط حروف و اعداد).',
	  '1002' => 'گذرواژه خیلی ساده می باشد. باید حداقل 8 کاراکتر بوده و از نام کاربری و ایمیل و شماره موبایل خود در آن استفاده نکنید.',
	  '1003' => 'مشکل در ثبت، با پشتیبانی تماس بگیرید.',
	  '1004' => 'مشکل در ثبت، با پشتیبانی تماس بگیرید.',
	  '1005' => 'مشکل در ثبت، با پشتیبانی تماس بگیرید.',
	  '1006' => 'تاریخ ارسال پیام برای گذشته می باشد، لطفا تاریخ ارسال پیام را به درستی وارد نمایید.',
	  '1401' => 'اعتبارسنجی کاربر خطا دارد.',
	  '1402' => 'کلید وب سرویس معتبر نیست',
	  '1403' => 'کلید وب سرویس لغو شده است.',
	  '10001' => 'اعتبار پنل کافی نیست.',
	  '10002' => 'متن پیام خالی است.',
	  '10003' => 'کاربر محدود گردیده است.',
	  '10004' => 'شماره ارسال کننده به شما تعلق ندارد.',
	  '10005' => 'مخاطب پیامک خالی است.',
	  '10006' => 'اعتبار پنل کافی نیست.',
	  '10007' => 'خط مورد نظر برای ارسال انبوه مناسب نمیباشد.',
	  '10008' => 'خط ارسال کننده به صورت موقت غیرفعال شده است.',
	  '10009' => 'مخاطبان بیش از حد مجاز است.',
	  '10010' => 'درگاه پیامک غیرفعال است.',
	  '10011' => 'قیمتگذاری در پنل کاربر انجام نشده است.',
	  '10012' => 'تیکت غیرمعتبر است.',
	  '10013' => 'دسترسی ممنوع است.',
	  '10014' => 'پترن نامعتبر است.',
	  '10015' => 'پارامترهای پترن نامعتبر است.',
	  '10016' => 'پترن غیرفعال است.',
	  '10017' => 'گیرنده پیامک پترن نامعتبر است.',
	  '10019' => 'ارسال از این خط در ساعات شبانه ممنوع است.',
	  '10021' => 'برخی مدارک شما تایید نشده است.',
	  '10022' => 'خطای داخلی.',
	  '10023' => 'خط ارسال کننده یافت نشد',
	  '12404' => 'خط ارسال کننده یافت نشد',
	  '13001' => 'کارت ملی تایید نشده است',
	  '13002' => 'شماره کارت بانکی شما تایید نشده است',
	  '13003' => 'رمز عبور شما بسیار ضعیف است',
	  '13004' => 'خط ارسالی متعلق به شما نیست',
	  '13005' => 'پترن غیر فعال است.',
	  '13006' => 'شما نمی توانید از این پترن استفاده نمایید.',
	  '13007' => 'پترن در دسترس نیست.',
	  '13008' => 'گیرنده نامعتبر است.',
	  '13009' => 'درگاه غیرفعال است.',
	  '13010' => 'پارامتر های پترن نامعتبر است.',
	  '13011' => 'مقادیر پترن خیلی طولانی است.',
	  '13012' => 'پارامتر های پترن نامعتبر است.',
	  '13403' => 'ارسال کد تایید صوتی در پنل شما فعال نشده است. با پشتیبانی هماهنگ کنید.',
	  '422' => 'خطایی در ورودی ها وجود دارد.',
	 );
	 return (isset($errorCodes[$error])) ? $errorCodes[$error] : 'اشکال تعریف نشده با کد :' . $error;
	}
}
}
add_filter( 'digits_sms_gateways', 'ippanel_sms_gateway',10);
function ippanel_sms_gateway($gateways){
		$gateways = array();
		$gateways['ippanel'] = array(
			'value' => 10000,
			'label' => 'ippanel (Username & Password)',
			'inputs' => array(
				'نام کاربری پنل پیامک' => array(
					'text' => true,
					'name' => 'username',
				),
				'رمز عبور پنل پیامک' => array(
					'text' => true,
					'name' => 'password',
				),
				'خط ارسال کننده پیامک' => array(
					'text' => true,
					'name' => 'sender',
				),
				'دامنه سامانه پیامک. پیش فرض: ippanel.com' => array(
					'text' => true,
					'name' => 'domain',
					'optional' => 0,
				),
				'ارسال بر اساس پترن - ارسال سریع' => array(
					'options' => array(
						__('Yes') => 1,
						__('No') => 0
					),
					'name' => 'sendpattern',
					'optional' => 1
				),
				'کد پترن' => array(
					'text' => true,
					'name' => 'patterncode',
					'optional' => 1
				),
				'متغیرهای پترن(هر متغیر در یک خط)' => array(
					'textarea' => true,
					'name' => 'patternvars',
					'optional' => 1
				),
			)
		);
		$gateways['ippanelapikey'] = array(
			'value' => 10001,
			'label' => 'ippanel (API Key)',
			'inputs' => array(
				'API Key - کلید وب سرویس' => array(
					'text' => true,
					'name' => 'apikey',
				),
				'خط ارسال کننده پیامک' => array(
					'text' => true,
					'name' => 'sender',
				),
				'دامنه سامانه پیامک. پیش فرض: ippanel.com' => array(
					'text' => true,
					'name' => 'domain',
					'optional' => 0,
				),
				'ارسال بر اساس پترن - ارسال سریع' => array(
					'options' => array(
						__('Yes') => 1,
						__('No') => 0
					),
					'name' => 'sendpattern',
					'optional' => 1
				),
				'کد پترن' => array(
					'text' => true,
					'name' => 'patterncode',
					'optional' => 1
				),
				'متغیرهای پترن(هر متغیر در یک خط)' => array(
					'textarea' => true,
					'name' => 'patternvars',
					'optional' => 1
				),
				'فعالسازی ارسال مجدد کد به صورت صوتی' => array(
                    'options' => array(
                        __('Yes') => 1,
                        __('No') => 0
                    ),
					'name' => 'sendvoiceotp',
					'optional' => 1
				),
				'ارسال پیامک بین الملل' => array(
					'options' => array(
						__('Yes') => 1,
						__('No') => 0
					),
					'name' => 'sendinternational',
					'optional' => 1
				),
				'کد پترن بین الملل' => array(
					'text' => true,
					'name' => 'internationalpatterncode',
					'optional' => 1
				),
				'متن پیامک بین الملل یا متغیرهای پترن بین الملل' => array(
					'textarea' => true,
					'name' => 'internationalpatternvars',
					'optional' => 1
				),
			)
		);
	return $gateways;
}
add_filter( 'unitedover_send_sms', 'ippanel_sms_digits_send', 10, 8);
function ippanel_sms_digits_send($value, $option_slug, $gateway_id, $countrycode, $mobile, $messagetemplate, $testCall, $otp){
		try
		{

            $type = 'normal';
            switch($gateway_id){
				case '10000' :
					$ippanel_sms = get_option('digit_ippanel');
				break;
				case '10001':
					$ippanel_sms = get_option('digit_ippanelapikey');
				break;
			}


            if(substr($mobile,0,1) == '0') $to =  $countrycode. substr($mobile,1); else $to = $countrycode . $mobile;
            $dig_messagetemplate = '';


            if($countrycode == '+98') {
                $sendpattern = $ippanel_sms['sendpattern'];
                $patterncode = $ippanel_sms['patterncode'];
                if ($sendpattern == 1) {
                    $ippanel_sms['patternvars'] = str_replace("\r\n", ";", $ippanel_sms['patternvars']);
                    $ippanel_sms['patternvars'] = str_replace("\n", ";", $ippanel_sms['patternvars']);
                    $dig_messagetemplate = "patterncode:" . $patterncode . ";" . $ippanel_sms['patternvars'];
                    $type = 'pattern';
                } else {
                    $dig_messagetemplate = $messagetemplate;
                    $type = 'normal';
                }
                if(isset($_REQUEST['voice'])){
                    $type = 'voice';
                }
            } elseif(isset($ippanel_sms['sendinternational']) &&  $ippanel_sms['sendinternational'] == 1){
                $patterncode = $ippanel_sms['internationalpatterncode'];
                if ($patterncode) {
                    $ippanel_sms['internationalpatternvars'] = str_replace("\r\n", ";", $ippanel_sms['internationalpatternvars']);
                    $ippanel_sms['internationalpatternvars'] = str_replace("\n", ";", $ippanel_sms['internationalpatternvars']);
                    $dig_messagetemplate = "patterncode:" . $patterncode . ";" . $ippanel_sms['internationalpatternvars'];
                    $type = 'internationalpattern';
                } else {
                    $dig_messagetemplate = $ippanel_sms['internationalpatternvars'];
                    $type = 'internationalnormal';
                }
            } else {
                if ($testCall) return 'تنظیمات درگاه برای ارسال پیامک بین الملل نادرست است.';
                return false;
            }
            $dig_messagetemplate = str_replace('%OTP%', $otp, $dig_messagetemplate);
            $dig_messagetemplate = str_replace('{OTP}', $otp, $dig_messagetemplate);
			$ippanel = new digits_Ippanel( $ippanel_sms );

			$param = array
				(
					'message' => $dig_messagetemplate,
					'to' => $to,
					'countrycode' => $countrycode,
					'mobile' => $mobile,
                    'type' => $type,
                    'otp' => $otp,
				);
            $result = $ippanel->send( $param );
            // Check if the send was successful
			$success_message = 'ارسال موفقیت آمیز : ';
			$fault_message = 'خطا در ارسال. پاسخ پنل پیامک: ';
			$response = json_decode($result,true);
			if (is_numeric($response) || (is_array($response) && $response[0] == '0')) {
				if (is_numeric($response)) $res_code = 0; else $res_code = $response[0];
				if ($testCall) return $success_message.$ippanel->errors_describe($res_code);
				return true;
			}else{
				$res_code = $response[0];
				if ($testCall) return $fault_message. ' '.$res_code.'-'.$ippanel->errors_describe($res_code);
				error_log("Ippanel SMS failed :".json_encode(array('message'=>$dig_messagetemplate,'to'=>$mobile,'error'=>$ippanel->errors_describe($res_code))));
				return false;
			}
		}
		catch (Exception $e)
		{
			return false;
		}
}

add_action( 'wp_ajax_digits_ippanel_CheckPattern', 'digits_ippanel_CheckPattern' );
if(!function_exists('digits_ippanel_CheckPattern')){
	function digits_ippanel_CheckPattern() {
		if(isset($_POST['uname']) &&isset($_POST['pass']) &&isset($_POST['patternCode'])){

			$ippanel_sms = array(
				 'username'=> trim($_POST['uname']),
				 'password'=> trim($_POST['pass']),
				 'sender'=> 1,
			);

			$ippanel = new digits_Ippanel( $ippanel_sms );
			echo $ippanel->checkPattern($_POST['patternCode']);

		}else{
			echo '-1';
		}
		wp_die();
	}
}

add_action( 'wp_ajax_digits_ippanelapikey_CheckPattern', 'digits_ippanelapikey_CheckPattern' );
if(!function_exists('digits_ippanelapikey_CheckPattern')){
	function digits_ippanelapikey_CheckPattern() {
		if(isset($_POST['apikey']) &&isset($_POST['patternCode'])){

			$ippanel_sms = array(
				 'apikey'=> trim($_POST['apikey']),
			);

			$ippanel = new digits_Ippanel( $ippanel_sms );
			echo $ippanel->checkPatternApikey($_POST['patternCode']);

		}else{
			echo '-1';
		}
		wp_die();
	}
}
add_action('admin_enqueue_scripts', 'digits_ippanel_admin_script');
function digits_ippanel_admin_script($hook)
{
	if (isset($_GET['page']) && $_GET['page'] == 'digits_settings'){
		wp_enqueue_script('digits_ippanel_script_admin', plugins_url('digits_ippanel/gateways/ippanel/adminscript.js'), array(), null, 'all');
		wp_enqueue_style('digits-settings-custom', plugins_url('digits_ippanel/gateways/ippanel/custom-admin.css'), array(), digits_version(), 'all');
	}
}

add_action('wp_enqueue_scripts', 'digits_ippanel_front_script');
add_action('login_enqueue_scripts', 'digits_ippanel_front_script');
function digits_ippanel_front_script($hook)
{
	wp_enqueue_style( 'digits-front-custom', plugins_url( 'digits_ippanel/gateways/ippanel/custom.css' ), array(), digits_version(), 'all' );
}


add_action('digits_api_settings', 'digits_ippanel_admin_settings_footer');
function digits_ippanel_admin_settings_footer($hook)
{
add_thickbox();
?>
<div id="ippanel-pattern-modal-content" style="display:none; direction:rtl; text-align:right;">
<div style="direction:rtl; text-align:right;">
<p>	جهت ارسال سریع پیامک با خطوط خدماتی از این سامانه پیامکی، نیاز به ثبت پترن دارید. جهت ایجاد پترن ثبت آن در این افزونه از دستورالعمل زیر استفاده نمایید:</p>
<p>	وارد پنل پیامک خود شوید و در منوی پنل گزینه ارسال بر اساس پترن را کلیک کنید.</p>
<p>	در صفحه ظاهر شده روی دکمه + جدید کلیک کنید.</p>
<p>	مانند متن زیر یک الگو را تایپ کرده و دکمه ثبت را کلیک نمایید:</p>
<p>	<strong>کد تأیید شما: %code%<br />	نام فروشگاه یا سایت</strong></p>
<p>	(حتما نام فروشگاه خود را ثبت کنید و تنها یک متغیر در متن پیامک باید وجود داشته باشد)</p>
<p>	بعد از ثبت موفق الگو منتظر بمانید تا حداکثر 12 ساعت بعد الگوی شما تایید شود. وضعیت تایید یا رد الگوی خود را در همان صفحه پنل پیامکی خود می توانید مشاهده نمایید.</p>

<p>	پس از اینکه الگو تایید و فعال شد، تنظیمات درگاه افزونه دیجیتس (یعنی همین صفحه) را به شکل زیر انجام دهید:</p>
<p>	گزینه "ارسال بر اساس پترن" را روی بله تنظیم نمایید.</p>
<p>	در کادر "کد پترن" کد پترن ایجاد شده خود که در صفحه ارسال بر اساس پترن سامانه پیامک نمایش داده می شود ، وارد کنید و روی دکمه بررسی پترن کلیک کنید</p>
<p>	با این کار عبارت متناسب با ارسال پترن در کادر متغیرهای پیامکی درج خواهد شد که در مثال بالا عبارت <strong dir="ltr">code:{OTP}</strong> خواهد بود</p>
<p>	سپس دکمه ذخیره تغییرات را کلیک کنید.</p>
</div>
</div>
<?php
}
add_action('wp-login', 'digits_ippanel_clear_log');
function digits_ippanel_clear_log()
{
    $ip = isset($_SERVER["HTTP_CF_CONNECTING_IP"]) ? $_SERVER["HTTP_CF_CONNECTING_IP"] : $_SERVER["REMOTE_ADDR"];
    global $wpdb;
    $table_name = $wpdb->prefix . "digits_requests_log";
    $db = $wpdb->delete($table_name, array(
        'ip' => $ip,
        ),
    );
}
/*function d($data,$die = true, $file = 'debug', $new = false){
    if(is_array($data) || is_object($data)) $output = json_encode($data); else $output = $data;
    if($die) {
        echo '<pre>';
        print_r($data);
        exit;
    }
    $file= $file.'.txt';
    $debug_file_contents = @file_get_contents($file);
    if($new == false) $output = $debug_file_contents."\n".$output;
    file_put_contents($file,$output);
}*/
wp_enqueue_script('digits-ippanel-login-script');
wp_register_script('digits-ippanel-login-script', plugins_url('digits_ippanel/gateways/ippanel/login.js'), dig_deps_scripts(), digits_version(), true);


add_action("wp_ajax_nopriv_digits_resendotp_voice", "digits_resendotp_voice");

add_action("wp_ajax_digits_resendotp_voice", "digits_resendotp_voice");

function digits_resendotp_voice()
{

    $countrycode = sanitize_text_field($_REQUEST['countrycode']);
    $mobileno = sanitize_mobile_field_dig($_REQUEST['mobileNo']);
    $csrf = $_REQUEST['csrf'];
    $login = $_REQUEST['login'];

    if (dig_gatewayToUse($countrycode) == 1) {
        die();
    }
    if ($countrycode != '+98') {
        echo "-99";
        die();
    }

    if (!wp_verify_nonce($csrf, 'dig_form')) {
        echo '0';
        die();
    }

    $users_can_register = get_option('dig_enable_registration', 1);
    $digforgotpass = get_option('digforgotpass', 1);
    if ($users_can_register == 0 && $login == 2) {
        echo "0";
        die();
    }
    if ($digforgotpass == 1 && $login == 3) {
        echo "0";
        die();
    }

    if (OTPexists($countrycode, $mobileno, true)) {
        digits_check_mob();
    }
    echo "0";
    die();

}